﻿/*==============================================================================================
   HTML Parsing Blocks. The following vars contain HTML code to be inserted in the Register
   Today HTML pages based on the business logic, e.g., whether the registration is for a company
   or individual, whether an old serial number is needed, whether State/Region/Province is 
   required, etc.

   (C) Copyright 2004 by Autodesk, Inc.  All rights reserved.
  ==============================================================================================*/

/////////////////////////////////////////////
// LOCALIZATION RESOURCES HERE:
/////////////////////////////////////////////

/////////////////////////////////////////////
// Product Language: 
//
// NOTE TO LOCALIZATION: The list below was inserted on 29 Jan 2001 and it was up to date at that point.
// You may use the codes detailed below if you are sure that these have not changed (they generally don't change), otherwise, 
// please check these before inserting the language code.
/////////////////////////////////////////////
//
//English - US and International:  (en-us)
//German:  (de)
//French:   (fr)
//Italian:   (it)
//Spanish:   (es)
//Czech:   (cs)             
//Hungarian:   (hu)
//Polish:   (pl)
//Russian:   (ru)
//Japanese:   (ja)
//Korean:   (ko)
//Traditional Chinese (Taiwan) :   (zh-tw)
//Simplified Chinese (PRC) :   (zh-cn)
//Brazilian Portuguese (pt-br)
//
/////////////////////////////////////////////

//////////////////////////////////////////////
///// Add as ECO17 Direct Addition to the Privacy Policy 
/////
var xmsgGatherInfoDuringInstall= "請注意，在產品啟用過程中收集的所有資料均應依照 Autodesk 的要求進行使用 ";
var xmsgOfflinePrivacyWarning= "如果您沒有連接至網際網路，請將 Internet Explorer (R) 瀏覽器的編碼設為自動選取以檢閱隱私權聲明。如果您能連接至網際網路，您可以造訪 autodesk.com 以檢閱隱私權聲明。"
////////////////////////////////////////////////////

var xmsgProductLanguage=	"zh-tw";

/////////////////////////////////////////////
// Disable field color
/////////////////////////////////////////////
var xmsgDisableColor=		"#7f7f7f";

var xmsgNavigationBGColor=	"#f4f4f4";
var xmsgNavigationDisableColor=	"#808080";

/////////////////////////////////////////////
// HTML FILE TITLE STRINGS
/////////////////////////////////////////////
var xmsgRTAuthConfirmed=				"啟用完成";
var xmsgRTActLicFound=                  "找到已啟用的授權";
var xmsgRTActLicFoundError=            "註冊 - 啟用錯誤"; 
var xmsgRTAuthEntryError=				"啟用項目錯誤";
var xmsgRTAuthError=					"啟用錯誤";
var xmsgRTAuthNow=						"立即授權";
var xmsgRTBeginReg=						"啟用選項";
var xmsgRTBuyInformation=				"訂購資訊";
var xmsgRTConfirm=						"使用者確認";
var xmsgRTConnect=						"需要網際網路連線";
var xmsgRTConnectFail=					"連線錯誤";
var xmsgRTContactAutodesk=				"連絡 Autodesk";
var xmsgRTCountryPage=					"國家和地區";
var xmsgRTEmail=						"電子郵件";
var xmsgRTFaxUS=						"使用者傳真 US";
var xmsgRTMailUS=						"使用者郵件 US";
var xmsgRTPurchaseOffline=				"離線購買";
var xmsgRTRegConfirmed=					"註冊已確認";
var xmsgRTExportConfirm=                "授權匯出確認";
var xmsgRTImportConfirm=                "授權匯入確認"; 
var xmsgRTRegVol=						"產品註冊";
var xmsgRTSUNDataConfirm=				"SUN 資料確認";
var xmsgRTSUNServer=					"SUN 伺服器";
var xmsgRTSUNSubmit=					"使用者確認/提交 SUN";
var xmsgRTUserInfo=						"使用者資訊";
var xmsgRTLicFileSaveError=				"Flexlm 授權檔儲存錯誤";
var xmsgRTProductInfo=                   "需要產品資訊";
var xmsgNSARTBegin=						"取得網路授權";
var xmsgNSARTLocateLicense=				"尋找授權檔";
var xmsgNSARTEditServerAndSeat=			"輸入修改伺服器資訊";
var xmsgNSARTConfirmServerAndSeat=		"確認伺服器資訊";
var xmsgNSARTEnterSN=					"輸入序號";
var xmsgProcessingError=				"處理錯誤";
var xmsgTimeout=        				"此階段作業已逾時";
var xmsgLicenseActivation=        		"正在啟用";
var xmsgLicenseTransfer=        		"授權轉移";

/////////////////////////////////////////////
// Software Information RESOURCES HERE:
/////////////////////////////////////////////
var xmsgActivationFor=	"啟用:";
var xmsgPurchase=       "購買:";
var xmsgRegistrationFor=       "註冊:";
var xmsgProduct=	"產品: ";
var xmsgsernum=		"序號: ";
var xmsgsernumWGID=	"序號: ";//modify by joyce.min on 2007-8-16
var xmsgprokeyWGID=  "產品金鑰: "; // add by  joyce.min on 2007-8-16
var xmsgOsernum=	"舊序號: ";
//var xmsgOprokey=      "Previous product key: "; // add by joyce.min on 2007-8-17
var xmsgOldSerialNum=	"舊序號:*";
var xmsgNewSernum1=	"輸入序號或群組 ID:"; //???
//var xmsgNewProkey1=
var xmsgRequestCode=	"需求碼: ";
var xmsgRegAuthCode=	"啟用碼: ";
var xmsgApplicationKey=	"應用程式碼: ";
var xmsgRTHostID=				"主電腦 ID:";
var xmsgRTFlexlmLicenseFile=	"授權檔:";

/////////////////////////////////////////////
// Primary Rolodex RESOURCES HERE:
/////////////////////////////////////////////
var xmsgSalutation=	"稱謂:";
var xmsgNone=		"(無)";
var xmsgNotEntered=	"(未輸入)";
var xmsgFirstname=	"名字:";
//var xmsgFirstname= langCode+label.fname;
var xmsgFirstnameKanji=	"名字 (日文漢字):";
var xmsgFirstnameFurigana=	"名字 (全使用日文假名):";
var xmsgLastname=	"姓氏:";
var xmsgLastnameKanji=	"姓氏 (日文漢字):";
var xmsgLastnameFurigana=	"姓氏 (全使用日文假名):";
var xmsgCompanyName=	"公司名稱:*";
var xmsgCompanyName2=	"公司名稱:";
var xmsgCompanyNameJP=	"公司名稱 (日文漢字):";
var xmsgPhone=		"電話:";
var xmsgArea=		"區號:";
var xmsgNumber=		"號碼:";
var xmsgExt=		"分機:";
var xmsgFax=		"傳真:";
var xmsgFaxTo=		"傳真至";
var xmsgEmail=		"電子郵件:";
var xmsgEmailTo=	"傳送電子郵件至";
var xmsgAddress=	"街道地址:";
var xmsgAddress2=	"街道地址 2:";
var xmsgAddress3=	"街道地址 3:";
var xmsgJPAddress=	"城鎮:";
var xmsgJPAddress2=	"街道地址:";
var xmsgJPAddress3=	"建築名稱 (與房間號碼):";
var xmsgCity=		"城巿:";
var xmsgSRP=		"州/地區/省:";
var xmsgStText=		"州:";
var xmsgPrText=		"省:";
var xmsgRegText=	"地區:";
var xmsgPrefectureText=	"縣:";
var xmsgCountyText=	"郡:";
var xmsgCantonText=	"鎮:";
var xmsgZipCode=	"郵遞區號:";
var xmsgPostCode=	"郵遞區號:";
var xmsgCountry=	"國家和地區:";
var xmsgDealer=		"Autodesk 授權經銷商名稱:";
var xmsgMailTo=		"郵寄至";
var xmsgAnEmail=	"電子郵件地址";
var xmsgAFax=		"傳真號碼";
var xmsgAMailAddress=	"郵寄地址";
var xmsgPostalMail=		"郵遞郵件";

///////////////////////////////////////////////
// Button RESOURCES HERE:
///////////////////////////////////////////////
var xmsgBack=			"上一步";
var xmsgCancel=			"關閉";
var xmsgNext=			"下一步";
var xmsgPrint=			"列印";
var xmsgPrintForm=		"開啟啟用請求表格";
var xmsgNo=				"否";
var xmsgYes=			"是";
var xmsgBrowse=			"瀏覽";
var xmsgDone=			"完成";
var xmsgOK=				"確定";
var xmsgClose=			"關閉";
var xmsgSubmit=			"提交";
var xmsgFinish=			"完成";
var xmsgReset=			"全部清除";

///////////////////////////////////////////////
// Registration User Prompt RESOURCES HERE:
///////////////////////////////////////////////
var xmsgPleaseSelect=		"請選取 ";
var xmsgPleaseSelect2=		"若要立即啟用您的 %1 授權，請再次選取「立即連線並啟用！」。如果啟用過程中仍遇到問題，並且您已請求並從 Autodesk 收到啟用碼，請選取「我擁有來自 Autodesk 的啟用碼」。";
var xmsgSelectCountry=		"該產品將要使用的國家/地區:";
var xmsgSelectCountry2=		"國家/地區:";
var xmsgInformation=		"資訊";
var xmsgCompanyInfo=		"公司資訊:";
var xmsgContactInfo=		"連絡資訊:";
var xmsgResponseMethodInfo=	"回應方式資訊:"; //modify as the Spec. recommond by joyce.min on 2007-8-17
var xmsgFormSubmitMethodInfo=	"表格提交方式:";
var xmsgConfirmInfo=		"確認資訊";
var xmsgConfirmInfoTxt=		"請檢閱以下資訊。按一下表格提交方式連結之一以繼續 (使用展示的資訊)，或按一下「上一步」以進行變更。";
var xmsgConfirmCustIDInfoTxt=		"請確認以下資訊。按一下「下一步」以繼續，或按一下「上一步」以進行變更。";
var xmsgCountryHdr=			"產品註冊";
var xmsgCountryRegTo=		"此產品將註冊給:";
var xmsgCountryComp=		"公司";
var xmsgCountryIndiv=		"個人";
var xmsgCountryUpgrade=		"這是一個升級版本";
var xmsgCountryUpgDetail=	"(如果您是 Subscription 客戶，請按一下「否」)";
var xmsgConnectHdr1=		"正在連線";
var xmsgConnectHdr2 = "正在啟用您的產品授權…";
var xmsgConnectHdr = "需要網際網路連線";
var xmsgConnectMsg=		"連線";
var xmsgConnectTxt=		"未偵測到網際網路連線。若要線上啟用，請立即連線到網際網路。建立連線後，請按一下「下一步」。";
var xmsgConnectTxtOLT=    "未偵測到任何網際網路連線。若要轉移授權，請立即連線到網際網路。";
var xmsgConnectTxt2=	"建立網際網路連線後，按一下「下一步」。";
var xmsgConnectTxt3=	"如果您無法存取網際網路，請使用離線方式向 Autodesk 請求啟用碼。";
var xmsgConnectWarming=	"提交此資訊可能會花費幾分鐘。請稍候。";
var xmsgTryAgain=		"請再試一次";
var xmsgReEnterOld=		"重新輸入舊序號";
var xmsgNewSernum3=		"請輸入新序號，然後按一下「下一步」。";
var xmsgNewSernum4=		"您的試用軟體在安裝時使用的是無法註冊的序號 (000-00000000)。如果您有購買此軟體，則會發給您一個新序號。您必須使用此序號來啟用您的產品，才能夠使用它。";
var xmsgNewSernum5=		"輸入序號:"; //modify by joyce.min on 2007-8-16
var xmsgProductKey=      "輸入產品金鑰:"; //modify by joyce.min on 2007-8-16
var xmsgNewSernum6=		"確認新序號:";
var xmsgNewSernum8=		"重新輸入新序號";
var xmsgUseOtherMethod=		"請使用其它註冊方法";
var xmsgContactAutodesk=	"連絡 Autodesk";
var xmsgContactAutodeskLink="若要聯絡 Autodesk，請按一下以下連結:";
var xmsgContactOptions=		"連絡方法列出如下。";

var xmsgPuchaseInfo1=		"訂購資訊";
var xmsgPuchaseInfo2=		"您已選擇線上購買。"; //modify as the LF1_Spec_SCV commend on p99 by joyce.min
var xmsgPuchaseInfo3=		"按一下「下一步」以繼續，或按一下「取消」以停止。"; //modify as the LF1_Spec_SCV commend on p99 by joyce.min

var xmsgRegTitle=		"註冊 - 啟用";
var xmsgRegTitleBuy=		"線上訂購 Autodesk 產品";
var xmsgRegTitleNSA=		"網路授權啟用";
var xmsgRegInfo=		"客戶資訊";
var xmsgRegInfo2=		"註冊方法";
var xmsgRegInfo3=		"請選取一種註冊方法，然後按一下「下一步」。";
var xmsgRegmethod1=		"直接通過網際網路連線";
var xmsgRegmethod3=		"我希望透過以下方式接收啟用碼:";
var xmsgRegmethod5=		"郵寄";
var xmsgRegmethod6=		"請按一下位於下方的「列印」，並將這個表格寄給:";
var xmsgRegmethod7=		"傳真";
var xmsgRegmethod8=		"若要在 %1 列印可以傳真至 Autodesk 的表單，請先選擇您要接收啟用碼的方式。然後，按一下「列印」。然後您便可以傳真表單了。";
var xmsgRegmethod9=		"電子郵件";
var xmsgRegmethod10NSA=		"已將下面展示的註冊資訊及授權伺服器資訊自動儲存至檔案。";
var xmsgRegmethod10=		"您的註冊資訊已儲存至以下檔案，它將用於完成電子郵件處理 (請勿修改此檔案):";
var xmsgRegmethod11NSA=		"將註冊資訊和授權伺服器資訊檔案 %1 透過電子郵件傳送到 %2。";
var xmsgRegmethod11=		"將註冊資訊檔案 %1 透過電子郵件傳送到 %2。";
var xmsgRegmethod12=		"確定您不會修改此檔案。<p>建議您列印一份此頁面的複本，並保存在安全的地方。您將需要此資訊來手動完成電子郵件程序。<p>您可以列印此資訊的複本以便記錄。按一下「完成」以關閉此應用程式。";
var xmsgRegmethod13=		"若要自動貼附並傳送 %1 至 Autodesk，請按一下以下連結。";
var xmsgRegmethod14=		"透過電子郵件傳送我的請求";
var xmsgRegmethod15=		"注意事項: 該電子郵件地址是自動的。請勿傳送電子郵件通訊至該地址。";
var xmsgRegmethod16=		"若要透過傳真或透過郵件進行註冊，請按一下下列其中一個連結:";
var xmsgRegmethod17=		"傳送電子郵件時發生錯誤";
var xmsgRegmethod18NSA=		"系統嘗試自動傳送註冊資訊和授權伺服器資訊時發生錯誤。";
var xmsgRegmethod18=		"系統嘗試自動傳送註冊資訊時發生錯誤。";
var xmsgRegmethod19=		"透過電子郵件手動傳送檔案:";
var xmsgRegmethod20NSA=		"將註冊資訊和授權伺服器資訊檔案 %1 透過電子郵件傳送到 %2。";
var xmsgRegmethod20=		"將註冊資訊檔案 %1 透過電子郵件傳送到 %2。";
var xmsgRegmethod21=		"確定您不會修改此檔案。<p>建議您列印一份此頁面的複本，並保存在安全的地方。您將需要此資訊來手動完成電子郵件程序。<p>您可以列印此資訊的複本以便記錄。按一下「完成」以關閉此應用程式。";
var xmsgRegAuthInfo=		"產品授權啟用選項";
var xmsgRegAuthInfo1=		"註冊確認";
var xmsgRegExpConfirm=      "授權匯出確認";
var xmsgRegImpConfirm=      "授權匯入確認";
var xmsgRegAuthInfo2 =      "立即連線並啟用！(建議)";
var xmsgRegAuthInfo2Hover = "與 Autodesk 連線並立即啟用您的產品授權 (需要網際網路連線)";
var xmsgRegAuthInfo3=		"輸入啟用碼"; 
var xmsgRegAuthInfo4=		"選取以下其中一個選項:";
var xmsgRegAuthInfo4A =     "我擁有來自 Autodesk 的啟用碼";
var xmsgRegAuthInfo4AHoverA = "鍵入您已請求並從 Autodesk 收到的啟用碼。<br>若要簡化此步驟，請在第一個方塊中貼上整個啟用碼。其餘方塊將自動填寫。";
var xmsgRegAuthInfo4AHoverB = "請輸入檔案路徑和名稱，或瀏覽至 Autodesk 在您的電子郵件請求的回覆中提供的啟用檔。";
var xmsgRegAuthInfo4B=		"輸入啟用碼:"; 
var xmsgRegAuthInfo5=		"請選取國家或地區，輸入啟用碼並按「下一步」。";
var xmsgRegAuthInfo6=		"產品授權啟用";	
var xmsgRegAuthInfo7=		"已成功啟用 %1！";
var xmsgRegAuthInfo8=		"確認";		
var xmsgRegAuthInfo9=		"謝謝您註冊您的 Autodesk 產品。這項資訊會協助我們在日後提供您更好的服務。";
var xmsgRegAuthInfo10=		"已將啟用資訊的複本儲存至:";		
var xmsgRegAuthInfo10B=		"已將啟用資訊的複本儲存至:";
var xmsgRegAuthInfo14=		"恭喜您成功購買了 %1。根據已啟用授權的條款，您可以在自己的電腦上執行一個或多個產品。";
var xmsgRegAuthInfo15=		"解除安裝 %1 不會移除授權。";
var xmsgRegAuthInfo16=		"授權有效";
var xmsgRegActLicInfo=      "找到已啟用的授權";
var xmsgRegActLicInfoError=      "註冊 - 啟用錯誤";
var xmsgRegActiveInfo=        "鍵入或瀏覽至啟用檔:";
var xmsgRegActLicInfo1=       "在此電腦上找到先前註冊並啟用的產品授權，現在正在使用。"
var xmsgRegActLicInfo1Error= "在此電腦上找到先前註冊並啟用的產品授權。\n但是發生了非預期錯誤 (%1)。請關閉該應用程式並重試。如果此問題仍然存在，請聯絡您的系統管理員或授權的 Autodesk 產品經銷商";

/////////////////////////////////////////////
// OLT Confirmation
/////////////////////////////////////////////
var xmsgExportSuccess=        "匯出成功"; //2008-01-16
var xmsgExportFail=           "匯出請求失敗" ; //2008-01-16
var xmsgRegErrRef=            "錯誤參考:"; //2008-01-17
var xmsgImportSuccess=        "匯入成功"; //2008-01-16
var xmsgImportFail=           "匯入請求失敗"; //2008-01-16
var xmsgExpSucessInfo=        "已成功匯出您的授權，該授權現在位於 Autodesk 伺服器上。"; //2008-01-16
var xmsgExpSuccessInfoHowtoImport=    "如何匯入您的授權";
var xmsgExpSucessInfo1=        "在目標電腦上啟動本產品之前，請使用授權轉移公用程式將此授權匯入至該電腦，並準備好輸入您的 Autodesk 使用者 ID 和密碼。";  //2008-01-16
var xmsgImpSucessInfo=         "已成功匯入授權；現在您可以使用本產品。 "; //2008-01-16
var xmsgImpRemindInfo=         "提醒我匯出。"; //2008-01-16
var xmsgImpRemindInfo1=        "如果勾選此方塊，則每次結束時都會顯示一個對話方塊，提醒您匯出授權。";//copy mockup 2008-01-16
var xmsgImpRemindInfo2=        "如果您要暫時將授權匯入此電腦並需要將授權轉移回去，則勾選此方塊非常有用。";//copy mockup 2008-01-16
var xmsgImpRemindInfo3=        "提醒中有一個「不再展示此訊息」選項。";//copy mockup 2008-01-16
var xmsgOltTryAgain=           "按一下「重試」連結以重新提交請求。 ";
var xmsgImpFailMsg=            "如果問題仍然存在，則您應當啟用授權而不是匯入授權。";

var xmsgReqfilelocMsg=       "請求檔案位於:";	//add by joyce.min on 2007-9-10 as Licensing Spec. recommend 	
var xmsgRegAuthInfo11=		"感謝您的註冊 - 您的產品已經啟用，並且您的授權檔已經儲存。請按一下「列印」以保留此資訊記錄。";
var xmsgRegAuthInfo12=		"貼上啟用碼。";
var xmsgRegAuthInfo13=		"鍵入啟用碼。";
var xmsgRegErrorActiveCode=    "<FONT color=red>輸入啟用碼以繼續。</FONT>";
var xmsgRegErrorActiveCode1=    "<FONT color=red>啟用碼無效。請檢查錯誤代碼。</FONT>";
var xmsgRegErrorActiveFile=    "<FONT color=red>輸入啟用檔路徑和名稱以繼續。</FONT>";
var xmsgRegErrorSernum=      "<FONT color=red>輸入序號以繼續。</FONT>"; //add by joyce.min on 2007-8-29
var xmsgRegErrorSernum1=      "<FONT color=red>序號太短。</FONT>"; //add by joyce.min on 2007-9-7
var xmsgRegErrorProkey=      "<FONT color=red>輸入產品金鑰以繼續。</FONT>"; //add by joyce.min on 2007-8-29
var xmsgRegErrorProkey1=     "<FONT color=red>產品金鑰太短。</FONT>"; //add by joyce.min on 2007-9-7
var xmsgRegErrorHdr=		"註冊 - 啟用錯誤";
var xmsgRegErrorSystem=		"某個暫時的系統問題導致您的註冊出現錯誤。請按一下下列其中一個連結。"
var xmsgRegErrorPrevReg=	"您輸入的序號已經被註冊。";
var xmsgRegErrorMaxAuth=	"已經超過本產品允許的啟用數。";
var xmsgRegErrorMaxAuth2=	"您已經超過本產品允許的授權數。";
var xmsgRegErrorInvalidOld=	"您輸入的舊版產品序號無效。請確認上面顯示的舊序號是否正確。請按一下下列其中一個連結。";
var xmsgRegErrorData=		"您提供的註冊資料有問題。請選取「再試一次」以檢閱並修正您輸入的資訊；使用其他註冊方法；或與 Autodesk 聯絡以繼續。";
var xmsgRegErrorNetwork=	"您嘗試註冊的產品是網路授權的產品，必須採用網路安裝。您必須解除安裝軟體並選取「網路」安裝類型。<p>請參閱安裝指南中的〈網路安裝〉一節，以取得有關網路版安裝與啟用的正確程序。";
var xmsgRegNoResponse=		"某個暫時的問題導致您的線上註冊出現錯誤。請按一下下列其中一個連結。";
var xmsgRegErrorAuthEntry=	"您輸入的啟用碼有問題。請按一下下列其中一個連結。";
var xmsgRegErrorAuthPermission = "若要啟用此 Autodesk 產品，必須擁有管理員權限，或由系統管理員提高權限。請洽詢系統管理員，以取得關於管理員與提高權限的更多資訊。";							
var xmsgRegErrorAuth=		"啟用碼有問題。請按一下下列其中一個連結。";
var xmsgRegErrorFlex=		"授權有問題。請按一下下列其中一個連結。";
var xmsgRegConnError=		"連線錯誤";
var xmsgRegConnErrorTxt=	"網際網路連線有問題。請按一下下列其中一個連結。";
var xmsgRegPurchError3=		"使用另一種訂購方式";
//modified as LFSpec_SCV commend by joyce.min
var xmsgRegPurchError5=		 "感謝您選擇購買 Autodesk 軟體。<p>完成此過程的連接目前無法使用，可能是因為您的系統設定有問題。<p>在下列任何一個連結上按一下將開啟您的瀏覽器，並可能會讓您成功連接。<p>";

var xmsgAuthResellerMsg1=	"從您當地的代理商處購買。請與您當地的代理商聯絡以完成您的購買。";

var xmsgLicSaveErrInfo=		"儲存授權檔時出現錯誤。請按一下下列其中一個連結。";

var xmsgOnlineStoreMsg1=	"在 Autodesk 線上商店購買。如果您無法在商店裡找到要尋找的產品，請與授權經銷商聯絡。";
var xmsgOnlineStoreMsg2=    "線上商店";
var xmsgAuthResellerMsg2=	"授權代理商";
var xmsgLocateLicenseMsg1=	"尋找授權檔";
var xmsgLocateLicenseMsg2=	"輸入授權檔的路徑 (或使用「瀏覽」功能尋找一個路徑)，然後按一下「下一步」以繼續。";
var xmsgLocateLicenseMsg3=	"既有的授權檔:";
var xmsgUserContactMsg=		"您必須至少輸入下列其中一個選項:";
var xmsgFailureMsg=		    "無法處理您的線上啟用請求。";

/////////////////////////////////////////////
// Default Ereg returned error messages
/////////////////////////////////////////////
var xmsgDefaultEregReturnedErrMsg=  "您的線上啟用請求傳回一個錯誤 (%1)，不允許使用自動系統處理您的請求。";
var xmsgRegErrorOnline=		"請按一下以下「使用其他方式」連結，以完成所需表格並將您的請求提交至當地的 Autodesk 商務中心。客戶服務代表將在兩個工作日內回應。";
var xmsgAnotherFormSubmitMethod=    "使用其他方式";
var xmsgOfflineRegistrationMethod=    "使用離線方式請求啟用碼";
var xmsgOfflineRegistrationMethodHover= "為您的產品授權準備啟用碼請求，並透過電子郵件、電話或傳真傳送給 Autodesk。";

/////////////////////////////////////////////
// Timeout message
/////////////////////////////////////////////
var xmsgTimeoutMsg1=    "您的線上啟用請求已逾時。"
var xmsgTimeoutMsg2=    "按一下「再試一次」連結，重新提交線上請求。如果問題依然存在，您可以按一下「使用其他方式」連結，完成所需表格並使用電子郵件、傳真或其他選項來提交您的請求。";

/////////////////////////////////////////////
// Single User Network RESOURCES HERE:
/////////////////////////////////////////////
var xmsgRegSunData1=		"註冊資料已儲存";
var xmsgRegSunData2=		"用戶端佈署所需的註冊資料已經儲存在 ";
var xmsgRegSunData3=		"為此升級註冊所提供的舊序號是無效的。請與您的管理員連絡。";
var xmsgRegSunData4=		"必須使用有效的舊序號重新安裝此軟體。";
var xmsgRegSunData5=		"多套單機版部署";
var xmsgRegSunData6=		"若要完成多套單機版部署，需要一些註冊資訊。下列頁面將:";
var xmsgRegSunData7=		"收集必要資訊。";
var xmsgRegSunData8=		"如果升級時需要，則允許輸入舊序號。";
var xmsgRegSunData9=		"將本資訊儲存到伺服器上，以便對所有的用戶端安裝進行佈署。";
var xmsgRegSunData10=		"本軟體將使用下列資訊來完成註冊。請按一下「下一步」繼續。";

/////////////////////////////////////////////
// Voluntary RESOURCES HERE:
/////////////////////////////////////////////
var xmsgRegVol1=	"產品註冊";
var xmsgRegVol2=	"選取一個選項，然後按一下「下一步」:";
var xmsgRegVol3=	"現在註冊 - 選取這個選項以便開始線上註冊";
var xmsgRegVol4=	"以後註冊 - 選取這個選項以便現在執行軟體";
var xmsgRegVol5=	"不要再展示這個訊息。";
var xmsgRegVol6=	"（您以後註冊時，可選取「說明|關於」對話方塊中的註冊選項來完成）";

/////////////////////////////////////////////
// Japan RESOURCES HERE:
/////////////////////////////////////////////
var xmsgCustIDMainTitle=	"客戶識別";
var xmsgKatakana=		    "公司名稱 (全使用日文假名):";
var xmsgDepartment=		    "部門:";
var xmsgDepartment2=		"部門名稱";

/////////////////////////////////////////////
// Autodesk Contact RESOURCES HERE:
/////////////////////////////////////////////
var xmsgFormWebHdr=	"網址:";
var xmsgFormWebDataMsg1 = "您也可以透過造訪以下網站請求啟用碼:&nbsp;&nbsp;";
var xmsgFormEmailHdr=	"電子郵件:";
var xmsgFormEmailData=	"";
var xmsgFormEmailDataBlock= "";
var xmsgFormEmailXMLData=	"";
var xmsgFormEmailXMLDataBlock= "";
var xmsgFormFaxHdr=		"傳真:";
var xmsgFormFaxHdrLocal=	"當地辦事處傳真:";
var xmsgFormFaxHdrReg=	"傳真註冊:";
var xmsgFormFaxData=	"";
var xmsgFormFaxDataRegister=	"";
var xmsgFormCallHdr=	"電話:";
var xmsgFormCallData=	"";
var xmsgFormMailHdr=	"郵遞郵件:";
var xmsgFormMailHdrLocal=	"當地辦事處郵寄地址:";
var xmsgFormMailHdrReg=	"郵件註冊:";
var xmsgFormMailData=	"";
var xmsgFormMailDataRegister=   "";
var xmsgFormPurchHdr=	"訂購軟體";
var xmsgFormInternetMsg=    "若要使用網頁瀏覽器來請求啟用碼，請按一下連結。"
var xmsgFormEmailMsg=       "以電子郵件將通信和啟用請求傳送至:"

/////////////////////////////////////////////
// Privacy Statement RESOURCES HERE:
/////////////////////////////////////////////

var JPprivacystatement = "Autodesk 將使用您提供的資訊來註冊與/或發佈啟用碼。註冊即確認您同意 Autodesk 將您的相關資訊提供給我們授權的商業合作夥伴，以用於產品授權管理和授權確認之目的。如果您不希望 Autodesk 出於有限的目的而與其授權的商業合作夥伴共用您的資訊，請透過 <a href=mailto:information@autodesk.jp>information@autodesk.jp</a> 聯絡 Autodesk。如果您想修正或更新您的註冊資料，請按一下<a %1>此處</a>以聯絡 Autodesk，或者聯絡您當地的 Autodesk 辦事處。";
			
var privacystatement = "Autodesk 將使用您提供的資訊來註冊與/或發佈啟用碼，以使您持續獲悉我們的產品與服務資訊，並確保您因成為授權的 Autodesk 使用者而受益。Autodesk 不會將您的資訊出售或以其他方式提供給 Autodesk 或我們授權的商業合作夥伴以外的任何人。如果您想修正或更新先前註冊的客戶資訊，請按一下<a %1>此處</a>以聯絡 Autodesk，或者聯絡您當地的 Autodesk 辦事處。";
				
			
/////////////////////////////////////////////
// Privacy Policy
/////////////////////////////////////////////
var xmsgPrivacyPolicy="隱私權政策";

/////////////////////////////////////////////
// Copyright
/////////////////////////////////////////////
var xmsgCopyright="(c) Copyright 2009 Autodesk, Inc. 保留所有權利。"; //modify by joyce.min on 2007-8-14

/////////////////////////////////////////////
// Rebranding Message
/////////////////////////////////////////////
var xmsgRebranding="多數情況下，新序號將在您關閉程式並使用管理員權限重新啟動程式之後顯示。";
var xmsgRebranding2="請參考作業系統文件以獲取如何使用管理員權限啟動程式的資訊。";
/////////////////////////////////////////////
//  Note to Localization :
//
//	"InsertRegInfo" appears in RTUserInfo.html.  The full sentence in English is
//
//	"Fields marked in <FONT color=red>red</FONT> and with an asterisk (<FONT 
//	color=red>*</FONT>) are required to process your registration. Complete the form 
//	and click Next."
//
/////////////////////////////////////////////
var xmsgRegInfoMsg1= "標有 <FONT color=red>*</FONT> 的欄位必須填寫。";
var xmsgRegInfoMsg2= "您在此頁面上輸入的資訊將與您的授權儲存在一起。它用於重新啟用與升級產品。請確定在此處輸入有效的資訊，以避免延誤使用該產品。";

var xmsgLicLocationText1 = "將 <b>%1</b> 的授權檔儲存至:";

// Set Registration Info Header
var InsertRegInfo =     "<p><b>"+xmsgRegInfo+"</b></p>" +
			  "<p>" + xmsgRegInfoMsg1 + "</p>";


//=======================================================================
// Application Usage Information
//=======================================================================
var xmsgAppUsage=	"問題:";

var xmsgAppUsageQ1=	"為了協助 Autodesk 更好地瞭解您所在業界的需求，請回答以下問題。";
var xmsgAppUsageQ2=	"以下哪項描述最適合您所在的主要領域？";

var xmsgAppUsageOption51=	"航空航天與汽車零件設計 ";
var xmsgAppUsageOption52=	"建築設計 ";
var xmsgAppUsageOption53=	"建築物與設施管理 ";
var xmsgAppUsageOption54=	"建築構建: 商用 ";
var xmsgAppUsageOption55=	"建築構建: 居民區 ";
var xmsgAppUsageOption56=	"建築設備製造 ";
var xmsgAppUsageOption57=	"土木工程/土地規劃 ";
var xmsgAppUsageOption58=	"電腦/醫療/辦公設備設計 ";
var xmsgAppUsageOption67=	"消費者產品設計 ";
var xmsgAppUsageOption59=	"公司建築物所有權 ";
var xmsgAppUsageOption92=	"防禦 ";
var xmsgAppUsageOption93=	"電子控件設計 ";
var xmsgAppUsageOption94=	"電子系統工程 ";
var xmsgAppUsageOption72=	"環境工程 ";
var xmsgAppUsageOption95=	"合成金屬產品 ";
var xmsgAppUsageOption96=	"室內設計 ";
var xmsgAppUsageOption97=	"機械設計 ";
var xmsgAppUsageOption98=	"製造採購/銷售/行銷 ";
var xmsgAppUsageOption40=	"地圖繪製與地理空間設計 ";
var xmsgAppUsageOption41=	"機械系統工程 (HVAC 和管道) ";
var xmsgAppUsageOption42=	"配管工程和/或防火系統工程 ";
var xmsgAppUsageOption43=	"加工過程與電力廠設計 ";
var xmsgAppUsageOption44=	"房地產開發 ";
var xmsgAppUsageOption45=	"結構工程 ";
var xmsgAppUsageOption87=	"電子通訊 ";
var xmsgAppUsageOption46=	"工具和模具/機械工廠 ";
var xmsgAppUsageOption47=	"交通設計 ";
var xmsgAppUsageOption48=	"公用事業: 電、石油和天然氣 ";
var xmsgAppUsageOption49=	"公用事業: 淨水與污水 ";
var xmsgAppUsageOption99=	"其他 ";

var xmsgWrongCountryCodeMsg=	"錯誤: 輸入了未知的國家/地區碼！";

/////////////////////////////////////////////
// Version RESOURCES HERE:
/////////////////////////////////////////////
var xmsgVersion = "版本:"

/////////////////////////////////////////////
// Access RTFax or RTMail through RTEmail
/////////////////////////////////////////////
var xmsgAccessFaxMsg=		"將透過傳真或電話傳送我的請求"; //modify by joyce.min on 2007-10-18 as Licensing_Framework Spec_Frozen.doc recommend 
var xmsgAccessMailMsg=		"透過郵寄註冊。";
var xmsgAccessHereMsg=		"此處。";

/////////////////////////////////////////////
// Receive code by
/////////////////////////////////////////////
var xmsgReceiveCodeMsg=     "我希望透過以下方式取得此碼:";
var xmsgReceiveCodeMsg1=     "我將透過電子郵件接收我的啟用檔"; //add by joyce.min on 2007-8-20
/////////////////////////////////////////////
// Messages for Ease of reauth or multi-seat client registration
/////////////////////////////////////////////
var xmsgNoDialogHdrMsg=		"當確認您的<br>授權時，請稍候";
/////////////////////////////////////////////
//Resource for RTProductInfo
/////////////////////////////////////////////
var xmsgRTProductInfoTitle=      "需要產品資訊"; //add by joyce.min on 2007-8-14
var xmsgRTProductInfoMsg1=        "若要啟用您的 %1 授權，請輸入您的產品包裝上或「Autodesk 升級和授權資訊」電子郵件中的序號和產品碼。";
/////////////////////////////////////////////
//Error for RTProductInfo
/////////////////////////////////////////////
//var xmsgsernumError=        "Enter a serial number to proceed."; //add by joyce.min on 2007-8-17
//var xmsgprokeyError=        "Enter a product key to proceed." ; //add by joyce.min on 2007-8-17
/////////////////////////////////////////////
// Resource for NSA_RTBegin.html
/////////////////////////////////////////////
var xmsgNSARTBeginTitle=	"取得網路授權";
var xmsgNSARTBeginMsg1=		"透過以下方式請求網路授權啟用檔:";
var xmsgNSARTBeginMsg2=		"直接連線 (經由網際網路)";
var xmsgNSARTBeginMsg3=		"透過電子郵件、傳真或電話傳送請求";
var xmsgNSARTBeginNoInternet=	"";

/////////////////////////////////////////////
// Edit server and seat information
/////////////////////////////////////////////
var xmsgEditServerHdrMsg1=	"伺服器資訊";
var xmsgEditServerHdrMsg2=	"授權伺服器模型*";
var xmsgEditServerMsg1=		"輸入授權伺服器資訊。<br>按一下「查找」按鈕來植入「伺服器主電腦 ID」欄位。<p>";
var xmsgEditServerMsg2=		"從既有授權檔的伺服器主電腦資料開始。";
var xmsgEditServerRemove=	"移除";
var xmsgEditServerHostName=	"伺服器主電腦名稱*";
var xmsgEditServerHostID=	"主電腦 ID*";
var xmsgEditServerSeat=		"套數*";
var xmsgEditServerSingle=	"單一伺服器";
var xmsgEditServerDistributed=	"分散式伺服器";
var xmsgEditServerRedundant=	"同濟伺服器";
var xmsgEditServerDots=		"...";
var xmsgEditServerLookup=	"查找";
var xmsgEditServerAddServer=	"加入";
var xmsgEditServerRemoveServer=	"移除";
var xmsgEditServerTotal=	"總數:";
var xmsgEditServerExceedMaxServer=	"注意事項: 您一次最多可以授權 20 台分散式伺服器。如果需要授權 20 台以上伺服器，請與 Autodesk 聯絡。";
var xmsgEditServerSeatError=	"套數必須僅包含數值。";

var xmsgConfirmServerMsg=	"檢閱下列資訊。按一下「下一步」以繼續，或按一下「上一步」以進行變更。";
var xmsgConfirmServerMsg2=	"若按一下「下一步」，此資訊會經由網際網路傳送至 Autodesk。";
var xmsgConfirmServerHdr2=	"授權伺服器型式:";
var xmsgConfirmServerHostName=	"伺服器主電腦名稱";
var xmsgConfirmServerHostID=	"主電腦 ID";
var xmsgConfirmServerSeat=		"套數";
var xmsgConfirmServerTotal=		"總套數:";

var xmsgLicErrorHdr=			"授權錯誤"; 
var xmsgLicErrorInvalidSN=		"您輸入的序號無效。請確認上面顯示的序號是否正確。請按一下下列其中一個連結。";
var xmsgLicReEnterSN=			"重新輸入序號，並重試。";

var xmsgLic113Msg2=				"您為分散式伺服器配置的套數總數超過了該數目。";
var xmsgLic113ModifySeats=		"修改套數分散。";

var xmsgSaveLicenseHdr=			"已取得授權";
var xmsgSaveLicenseMsg1=		"您已從 Autodesk 取得授權。必須立即將其儲存至授權檔。<p> <b>將授權儲存至授權檔</b><p><LI><b>建議的授權檔位置</b>為您在伺服器上安裝 Autodesk 網路授權管理員的 \"License\" 目錄。";
var xmsgSaveLicenseMsg6=		"<LI>如果您具有<b>既有授權檔</b>，請將新授權<b>插入</b>其中。<br>您按一下「下一步」後，系統將自動將您的授權資訊插入至既有檔案的適當位置。</LI>";
var xmsgSaveLicenseMsg2=		"如果上面指定的檔案是既有授權檔:";
var xmsgSaveLicenseMsg3=		"請將新授權資訊插入該既有授權檔。";
var xmsgSaveLicenseMsg4=		"取代既有授權檔。";
var xmsgSaveLicenseMsg5=		"請修正以下錯誤:";

var xmsgSaveErrorFileNameTooLong=  "錯誤: 輸入的檔名太長。<br>請變更檔名然後繼續。";
var xmsgSaveErrorNoPermission=	"錯誤: 您不具有將檔案儲存至指定位置的許可權。<br>您可以先將該檔案儲存至暫存位置，取得適當的許可權後再移動它。";
var xmsgSaveErrorNoDiskSpace=	"錯誤: 您的磁碟空間不足，無法將該檔案儲存至指定位置。<BR>您可以先將該檔案儲存至暫存位置，取得可用空間後再移動它。";
var xmsgSaveErrorInvalidFile=	"錯誤: 無法在不遺失資料的情況下將新授權附加至指定的檔案。指定的檔案可能存在於其他機器或其他伺服器型式中。<BR>您可以使用其他名稱或位置儲存新授權檔，然後將其手動附加至指定檔案。";															
var xmsgSaveErrorPathNotExit=	"錯誤: 指定的路徑不存在。<BR>按一下瀏覽按鈕尋找或建立該路徑。";
var xmsgSaveErrorPathBlank=		"錯誤: 您必須指定有效的路徑與授權檔名稱。請在下面的欄位中指定路徑與檔案名稱，或者透過瀏覽來尋找路徑與檔案名稱。";

var xmsgLicAuthConfirmHdr1=		"授權啟用成功！";
var xmsgLicAuthConfirmHdr2=		"授權伺服器主電腦資訊";
var xmsgLicAuthConfirmMsg1=		"感謝您註冊產品。您可以列印此資訊的記錄。";
var xmsgLicAuthConfirmDate=		"日期:";

var xmsgLicPathMsg1=			"已經儲存以下授權檔:";
var xmsgLicPathMsg2=			"您的授權檔已經儲存至:";

var xmsgOtherMethodMsg1NSA=		"使用其他方式來取得授權。";
var xmsgOtherMethodMsg1=		"使用其他方式。";

var xmsgContactAutodeskMsg1=	"請使用下列其中一種方式聯絡 Autodesk。";
								
/////////////////////////////////////////////
// Email Options
/////////////////////////////////////////////
var xmsgEmailOptionNSATitle=	"透過電子郵件取得授權檔";
var xmsgEmailOptionTitle=		"透過電子郵件註冊";
var xmsgEmailOptionNSAMsg=		"已將註冊和授權伺服器資訊自動儲存至檔案。該檔案必須透過電子郵件傳送至 Autodesk 的自動註冊處理中心。<p>當您透過電子郵件將此檔案成功傳送至 Autodesk 後，將會收到自動回應、授權檔和有關如何完成此程序的說明。";
var xmsgEmailOptionMsg=			"已將註冊資訊自動儲存至檔案。該檔案必須透過電子郵件傳送至 Autodesk 的自動註冊處理中心。<p>當您透過電子郵件將此檔案成功傳送至 Autodesk 後，將會收到自動回應和有關如何完成此程序的說明。";
var xmsgEmailOptionMsg2=		"如果您使用的預設電子郵件系統目前可以經由網際網路傳送電子郵件，請按一下「立即傳送檔案」，然後按一下「下一步」。檔案將自動送出。<p>如果您現在沒有傳送電子郵件的存取權限，請按一下「稍後傳送檔案」。系統會提供手動傳送檔案的指示。";
var xmsgEmailOptionInfo1=		"立即傳送檔案。";
var xmsgEmailOptionInfo2=		"稍後手動傳送檔案。";
var xmsgEmailOptionInfo3=		"將電子郵件的複本傳送到我提供的電子郵件地址。";

/////////////////////////////////////////////
// Email Error
/////////////////////////////////////////////
var xmsgEmailErrorHdr=			"無法建立電子郵件";
var xmsgEmailErrorMsg1=			"若要透過電子郵件完成註冊，請將以下檔案貼附至電子郵件:";
var xmsgEmailErrorMsg2=			"傳送電子郵件至 %1。";
var xmsgEmailErrorMsg3=			"您可以在以下位置找到該檔案:";

/////////////////////////////////////////////
// Local HERE customer information URLs
/////////////////////////////////////////////
var xmsgLocalHERETitle=			"變更客戶資訊";
var xmsgLocalHEREInfo=			"若要變更客戶資訊，請聯絡您的 Autodesk 授權經銷商，或者導覽至下列適用於您所在國家或地區的連結。";
var xmsgLocalHEREUS=			"美國";
var xmsgLocalHEREEMEA=			"歐洲、中東、非洲";
var xmsgLocalHEREAPAC=			"亞太國家/地區";

/////////////////////////////////////////////
// Help
/////////////////////////////////////////////
var xmsgHelpTitle=				"說明";
var xmsgHelpUpgradeMsg=			"如果您要註冊或啟用來自舊版本的升級，則必須勾選此方塊，然後系統將提示您輸入正在升級版本的序號。";
var xmsgHelpUpgradeRequiredTitle=	"輸入舊版產品序號 (升級時必要)";
var xmsgHelpUpgradeRequiredMsg=	"這是舊版軟體的序號。您可以在軟體的「說明」>「關於」對話方塊中，或在舊版產品包裝上找到此序號。";

//	Fax or email error message
var xmsgNotEnterErrorMsg=		"您尚未輸入 %1。如果您希望透過此方式接收啟用碼，請將其輸入。";								

//  Help for serial number
var xmsgHelpSerialNumberTitle=  "序號/群組 ID"; ////modify by joyce.min on 2007-8-16
var xmsgHelpSerialNumberMsg=    "序號位於產品包裝上或在「 Autodesk 更新與授權資訊」電子郵件中。"; // ECO19

//  Help for ProductInfo serial number & Product Key //modify by joyce.min on 2007-8-16
var xmsgHelpProductKeyTitle=   "產品金鑰";
var xmsgHelpProductKeyMsg=    "產品金鑰位於產品包裝上的序號附近或在「Autodesk 更新與授權資訊」電子郵件中。"; // ECO19

/////////////////////////////////////////////
// The following strings are added back for backward competibility reason
/////////////////////////////////////////////
var xmsgRT0015TempSysErr=				"連線錯誤 (0.15)";
var xmsgRT010203071213CannotCompErrA=	"註冊錯誤 (1.2.3.7.12.13)";
var xmsgRT09AlreadyReg=					"已經註冊 (9)";
var xmsgRT10ExceededAuths=				"超越授權 (10)";
var xmsgRT12StolenSN=					"竊取的序號 (12)";
var xmsgRT18OldSNInvalid=				"無效的舊序號 (18)";
var xmsgRT20DataError=					"資料錯誤 (20)";
var xmsgRT21CustIDTelErr=				"客戶 ID/Tel 錯誤 (21)";
var xmsgRT22NetworkInstallation=		"網路安裝錯誤 (22)";
var xmsgRT900SystemNotResponding=		"系統無回應 (900)";
var xmsgRTCustID=						"客戶 ID";
var xmsgRTCustIDConfirm=				"確認身份";
var xmsgRTNewSerialNumber=				"新序號資訊";
var xmsgRTNoNewSN=						"訂購異動錯誤";
var xmsgRTPurchAuthFailed=				"啟用錯誤";
var xmsgRTPurchConfirmOther=			"購買確認";
var xmsgRTPurchConfirmPerm=				"購買確認 - 已註冊並啟用";
var xmsgRTPurchConfirmReg=				"購買確認 - 已註冊但未啟用";
var xmsgRTPurchConfirmRegVol=			"購買確認 - 已註冊";
var xmsgRTPurchConfirmRent=				"購買確認 - 已註冊並為租用中";
var xmsgRTPurchConfirmUnReg=			"購買確認 - 未註冊或未啟用";
var xmsgRTPurchConnectionFailed=		"購買連線失敗";
var xmsgRTPurchaseError=				"訂購錯誤";
var xmsgRTSNMismatch=					"購買異動錯誤 - 序號不相符";
var xmsgRTSUNOldSNInvalid=				"無效的舊序號 - SUN";

var szRTEmail =         "RTEmail.html";

var xmsgExit=			"結束";

var xmsgCustIDMainTitle=	"客戶識別";
var xmsgCustIDTitle1=		"客戶 ID:";
var xmsgCustIDText2=		"請在下面輸入您的客戶 ID 和電話號碼。如果您沒有客戶 ID，請將這兩個欄位留為空白。<p> ";
var xmsgCustIDText3=		"注意: 如果您要重新啟用產品，則必須輸入客戶 ID。";
var xmsgCustIDText3NSA=		"注意: 如果您要重新授權產品，則必須輸入客戶 ID。";
var xmsgCustIDTitle2=		"電話號碼:";
var xmsgCustIDTelEx4=		"（範例:  03-111-1234）";
var xmsgRegCustIDTel=		"您輸入的客戶 ID 及電話號碼與我們的記錄不符。請按一下下列其中一個連結。";

/////////////////////////////////////////////
//  Note to Localization :
//
//	"xmsgRT113SeatMsg1" appears in NSA_RT113TooManySeats.html.  The full sentence in English is
//
//	"Our records indicate that you have [Max allowed seats] valid [product name] seats available." 
/////////////////////////////////////////////
var xmsgRT113SeatMsg1=	"我們的記錄指出，您可以使用 %1 個有效的 %2 套數。<br>";

/////////////////////////////////////////////
// Error 12
/////////////////////////////////////////////
var xmsgErr12Hdr=				"您輸入的序號無效";
var xmsgErr12APAC=				"這是無效的序號，無法啟用。請透過 <a href=mailto:apacpl@listproc.autodesk.com target=\"_blank\">apacpl@listproc.autodesk.com</a></p> 聯絡我們";
var xmsgErr12EMEA=				"<p>尊敬的先生/女士</p><p>感謝您嘗試向 Autodesk 註冊 Autodesk&#0174; 或 Discreet&#0153; 軟體產品。</p><p>很抱歉，我們的記錄表明，您嘗試註冊之 Autodesk&#0174; 或 Discreet&#0153; 軟體產品的序號不是有效序號，或為該軟體產品之已知盜版版本的序號，因此，您正在使用的 Autodesk&#0174; 或 Discreet&#0153; 軟體產品未獲得授權。</p><p>Autodesk&#0174; 軟體產品的使用授權可以從 Autodesk 授權經銷商處購買。請造訪 <a href=\"http://www.autodesk.com\" target=\"_blank\">www.autodesk.com</a>，以取得您所在地區的 Autodesk 授權經銷商清單或 Autodesk 辦事處的資訊。使用合法的軟體是確保您從使用軟體中取得最大收益，以及避免因非法使用和/或複製軟體而引起潛在民事及刑事訴訟的唯一途徑。</p><p>Discreet&#0153; 軟體產品的使用授權可以從 Discreet 授權經銷商處購買。請造訪 <a href=\"http://www.discreet.com\" target=\"_blank\">www.discreet.com</a>，以取得您所在地區的 Discreet 授權經銷商的清單或 Discreet 辦事處的資訊。使用合法的軟體是確保您從使用軟體中取得最大收益，以及避免因非法使用和/或複製軟體而引起潛在民事及刑事訴訟的唯一途徑。</p><p>因此，我們誠摯地請求您立即停止使用您正嘗試註冊的未經授權的軟體產品，移除儲存於您電腦之任何硬體上的全部複本，並損毀包含該軟體產品的所有媒體。我們相信您會自願遵守我們的要求，同時 Autodesk 將保留與此事件相關的權利並會將您的詳細資料傳送至商業軟體聯盟 (「BSA」)。</p><p>如果您有任何疑問，或認為錯誤地收到了此訊息，請透過以下方式與我們聯絡: <a href=mailto:emea.register@autodesk.com target=\"_blank\">emea.register@autodesk.com</a></p><p>如果您願意提供關於使用或售賣非法軟體的資訊，請聯絡您當地的 Autodesk 辦事處，或透過造訪 <a href=\"http://www.BSA.org\" target=\"_blank\">www.BSA.org</a></p> 聯絡 BSA</p><p>謝謝</p>";
var xmsgErr12US=				"<p>尊敬的先生/女士</p><p>近期您曾嘗試在 Autodesk 或 Discreet 註冊您的軟體產品。</p><p>很抱歉，我們的記錄表明，您嘗試註冊之 Autodesk&#0174; 或 Discreet&#0153; 軟體產品的序號不是有效序號，或為該軟體產品之已知盜版版本的序號，因此，您正在使用的 Autodesk&#0174; 或 Discreet&#0153; 軟體產品未經授權。</p><p>對於 Autodesk 使用者，Autodesk&#0174; 軟體產品的使用授權可以從 Autodesk 授權經銷商處購買。請造訪 <a href=\"http://www.autodesk.com\" target=\"_blank\">www.autodesk.com</a>，以取得您所在地區的 Autodesk 授權經銷商的清單。使用合法的軟體是確保您從使用軟體中取得最大收益，以及避免因非法使用和/或複製軟體而引起潛在民事及刑事訴訟的唯一途徑。</p><p>對於 Discreet&#0153; 使用者，Discreet&#0153; 軟體產品的使用授權可以從 Discreet 授權經銷商處購買。請造訪 <a href=\"http://www.discreet.com\" target=\"_blank\">www.discreet.com</a>，以取得您所在地區的 Discreet 授權經銷商的清單或 Discreet 辦公室的資訊。使用合法的軟體是確保您從使用軟體中取得最大收益，以及避免因非法使用和/或複製軟體而引起潛在民事及刑事訴訟的唯一途徑。</p><p>您必須立即停止使用您嘗試從我們這裡註冊之未經授權的軟體產品，移除儲存於您電腦中的任何硬體上的全部複本，並且損毀包含該軟體產品的所有媒體。我們相信您會自願遵守我們的要求，同時 Autodesk 將保留與此事件相關的權利並會將詳細資料傳送至商業軟體聯盟 (「BSA」)。</p><p>如果您有任何疑問，或確信錯誤地收到了此訊息，請透過以下方式與我們聯絡: <a href=mailto:ProductActivation@activation.autodesk.com target=\"_blank\">ProductActivation@activation.autodesk.com</a></p><p>如果您願意提供關於使用或售賣非法軟體的資訊，請聯絡您當地的 Autodesk 辦公室，或透過造訪 <a href=\"http://www.BSA.org\" target=\"_blank\">www.BSA.org</a> 聯絡 BSA</p><p>謝謝</p> ";
// SIG // Begin signature block
// SIG // MIIVVAYJKoZIhvcNAQcCoIIVRTCCFUECAQExCzAJBgUr
// SIG // DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
// SIG // gjcCAR4wJAIBAQQQEODJBs441BGiowAQS9NQkAIBAAIB
// SIG // AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFNhllJZg/Obo
// SIG // /W6te7fYIHx/Ho7joIIRFjCCA3owggJioAMCAQICEDgl
// SIG // 1/r4Ya+e9JDnJrXWWtUwDQYJKoZIhvcNAQEFBQAwUzEL
// SIG // MAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJ
// SIG // bmMuMSswKQYDVQQDEyJWZXJpU2lnbiBUaW1lIFN0YW1w
// SIG // aW5nIFNlcnZpY2VzIENBMB4XDTA3MDYxNTAwMDAwMFoX
// SIG // DTEyMDYxNDIzNTk1OVowXDELMAkGA1UEBhMCVVMxFzAV
// SIG // BgNVBAoTDlZlcmlTaWduLCBJbmMuMTQwMgYDVQQDEytW
// SIG // ZXJpU2lnbiBUaW1lIFN0YW1waW5nIFNlcnZpY2VzIFNp
// SIG // Z25lciAtIEcyMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCB
// SIG // iQKBgQDEtfJSFbyIhmApFkpbL0uRa4eR8zVUWDXq0TZe
// SIG // Yk1SUTRxwntmHYnI3SrEagr2N9mYdJH2kq6wtXaW8alK
// SIG // Y0VHLmsLkk5LK4zuWEqL1AfkGiz4gqpY2c1C8y3Add6N
// SIG // q8eOHZpsTAiVHt7b72fhcsJJwp5gPOHivhajY3hpFHut
// SIG // LQIDAQABo4HEMIHBMDQGCCsGAQUFBwEBBCgwJjAkBggr
// SIG // BgEFBQcwAYYYaHR0cDovL29jc3AudmVyaXNpZ24uY29t
// SIG // MAwGA1UdEwEB/wQCMAAwMwYDVR0fBCwwKjAooCagJIYi
// SIG // aHR0cDovL2NybC52ZXJpc2lnbi5jb20vdHNzLWNhLmNy
// SIG // bDAWBgNVHSUBAf8EDDAKBggrBgEFBQcDCDAOBgNVHQ8B
// SIG // Af8EBAMCBsAwHgYDVR0RBBcwFaQTMBExDzANBgNVBAMT
// SIG // BlRTQTEtMjANBgkqhkiG9w0BAQUFAAOCAQEAUMVLyCSA
// SIG // 3+QNJMLeGrGhAqGmgi0MgxWBNwqCDiywWhdhtdgF/ojb
// SIG // 8ZGRs1YaQKbrkr44ObB1NnQ6mE/kN7qZicqVQh2wuceg
// SIG // jVfg+tVkBEI1TgHRM6IXyE2qJ8fy4YZMAjhNg3jG/FPg
// SIG // 6+AGh92klp5eDJjipb6/goXDYOHfrSjYx6VLZNrHG1u9
// SIG // rDkI1TgioTOLL4qa67wHIT9EQQkHtWUcJLxI00SA66HP
// SIG // yQK0FM9UxxajgFz5eT5dcn2IF54sQ6LKU859PfYqOrhP
// SIG // lAClbQqDXfleU/QYs1cPcMP79a2VoA4X3sQWgGDJDytu
// SIG // hgTx6/R4J9EFxe40W165STLyMzCCA8QwggMtoAMCAQIC
// SIG // EEe/GZXfjVJGQ/fbbUgNMaQwDQYJKoZIhvcNAQEFBQAw
// SIG // gYsxCzAJBgNVBAYTAlpBMRUwEwYDVQQIEwxXZXN0ZXJu
// SIG // IENhcGUxFDASBgNVBAcTC0R1cmJhbnZpbGxlMQ8wDQYD
// SIG // VQQKEwZUaGF3dGUxHTAbBgNVBAsTFFRoYXd0ZSBDZXJ0
// SIG // aWZpY2F0aW9uMR8wHQYDVQQDExZUaGF3dGUgVGltZXN0
// SIG // YW1waW5nIENBMB4XDTAzMTIwNDAwMDAwMFoXDTEzMTIw
// SIG // MzIzNTk1OVowUzELMAkGA1UEBhMCVVMxFzAVBgNVBAoT
// SIG // DlZlcmlTaWduLCBJbmMuMSswKQYDVQQDEyJWZXJpU2ln
// SIG // biBUaW1lIFN0YW1waW5nIFNlcnZpY2VzIENBMIIBIjAN
// SIG // BgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAqcqypMzN
// SIG // IK8KfYmsh3XwtE7x38EPv2dhvaNkHNq7+cozq4QwiVh+
// SIG // jNtr3TaeD7/R7Hjyd6Z+bzy/k68Numj0bJTKvVItq0g9
// SIG // 9bbVXV8bAp/6L2sepPejmqYayALhf0xS4w5g7EAcfrkN
// SIG // 3j/HtN+HvV96ajEuA5mBE6hHIM4xcw1XLc14NDOVEpkS
// SIG // ud5oL6rm48KKjCrDiyGHZr2DWFdvdb88qiaHXcoQFTyf
// SIG // hOpUwQpuxP7FSt25BxGXInzbPifRHnjsnzHJ8eYiGdvE
// SIG // s0dDmhpfoB6Q5F717nzxfatiAY/1TQve0CJWqJXNroh2
// SIG // ru66DfPkTdmg+2igrhQ7s4fBuwIDAQABo4HbMIHYMDQG
// SIG // CCsGAQUFBwEBBCgwJjAkBggrBgEFBQcwAYYYaHR0cDov
// SIG // L29jc3AudmVyaXNpZ24uY29tMBIGA1UdEwEB/wQIMAYB
// SIG // Af8CAQAwQQYDVR0fBDowODA2oDSgMoYwaHR0cDovL2Ny
// SIG // bC52ZXJpc2lnbi5jb20vVGhhd3RlVGltZXN0YW1waW5n
// SIG // Q0EuY3JsMBMGA1UdJQQMMAoGCCsGAQUFBwMIMA4GA1Ud
// SIG // DwEB/wQEAwIBBjAkBgNVHREEHTAbpBkwFzEVMBMGA1UE
// SIG // AxMMVFNBMjA0OC0xLTUzMA0GCSqGSIb3DQEBBQUAA4GB
// SIG // AEpr+epYwkQcMYl5mSuWv4KsAdYcTM2wilhu3wgpo17I
// SIG // ypMT5wRSDe9HJy8AOLDkyZNOmtQiYhX3PzchT3AxgPGL
// SIG // OIez6OiXAP7PVZZOJNKpJ056rrdhQfMqzufJ2V7duyuF
// SIG // PrWdtdnhV/++tMV+9c8MnvCX/ivTO1IbGzgn9z9KMIIE
// SIG // vzCCBCigAwIBAgIQQZGhWjl4389JZWY4HUx1wjANBgkq
// SIG // hkiG9w0BAQUFADBfMQswCQYDVQQGEwJVUzEXMBUGA1UE
// SIG // ChMOVmVyaVNpZ24sIEluYy4xNzA1BgNVBAsTLkNsYXNz
// SIG // IDMgUHVibGljIFByaW1hcnkgQ2VydGlmaWNhdGlvbiBB
// SIG // dXRob3JpdHkwHhcNMDQwNzE2MDAwMDAwWhcNMTQwNzE1
// SIG // MjM1OTU5WjCBtDELMAkGA1UEBhMCVVMxFzAVBgNVBAoT
// SIG // DlZlcmlTaWduLCBJbmMuMR8wHQYDVQQLExZWZXJpU2ln
// SIG // biBUcnVzdCBOZXR3b3JrMTswOQYDVQQLEzJUZXJtcyBv
// SIG // ZiB1c2UgYXQgaHR0cHM6Ly93d3cudmVyaXNpZ24uY29t
// SIG // L3JwYSAoYykwNDEuMCwGA1UEAxMlVmVyaVNpZ24gQ2xh
// SIG // c3MgMyBDb2RlIFNpZ25pbmcgMjAwNCBDQTCCASIwDQYJ
// SIG // KoZIhvcNAQEBBQADggEPADCCAQoCggEBAL687rx+74Pr
// SIG // 4DdP+wMQOL4I0ox9nfqSfxkMwmvuQlKM3tMcSBMl6sFj
// SIG // evlRZe7Tqjv18JScK/vyZtQk2vf1n24ZOTa80KN2CB4i
// SIG // JyRsOJEn4oRJrhuKof0lgiwQMOhxqyjod0pR8ezN+PBU
// SIG // 1G/A420Kj9nYZI1jsi1OJ/aFDv5t4ymZ4oVHfC2Gf+hX
// SIG // j61nwjMykRMg/KkjFJptwoRLdmgE1XEsXSH6iA0m/R8t
// SIG // kSvnAVVN8m01KILf2WtcttbZqoH9X82DumOd0CL8qTtC
// SIG // abKOOrW8tJ4PXsTqLIKLKP1TCJbdtQEg0fmlGOfA7lFw
// SIG // N+G2BUhSSG846sPobHtEhLsCAwEAAaOCAaAwggGcMBIG
// SIG // A1UdEwEB/wQIMAYBAf8CAQAwRAYDVR0gBD0wOzA5Bgtg
// SIG // hkgBhvhFAQcXAzAqMCgGCCsGAQUFBwIBFhxodHRwczov
// SIG // L3d3dy52ZXJpc2lnbi5jb20vcnBhMDEGA1UdHwQqMCgw
// SIG // JqAkoCKGIGh0dHA6Ly9jcmwudmVyaXNpZ24uY29tL3Bj
// SIG // YTMuY3JsMB0GA1UdJQQWMBQGCCsGAQUFBwMCBggrBgEF
// SIG // BQcDAzAOBgNVHQ8BAf8EBAMCAQYwEQYJYIZIAYb4QgEB
// SIG // BAQDAgABMCkGA1UdEQQiMCCkHjAcMRowGAYDVQQDExFD
// SIG // bGFzczNDQTIwNDgtMS00MzAdBgNVHQ4EFgQUCPVR6Pv+
// SIG // PT1kNnxoz1t4qN+5xTcwgYAGA1UdIwR5MHehY6RhMF8x
// SIG // CzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwg
// SIG // SW5jLjE3MDUGA1UECxMuQ2xhc3MgMyBQdWJsaWMgUHJp
// SIG // bWFyeSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eYIQcLrk
// SIG // HRDZKTS2OMp7A8y6vzANBgkqhkiG9w0BAQUFAAOBgQCu
// SIG // Ohe4SntV+mRV7ECk7UlBkJmcibyvLh3KeCP5HBkPf+to
// SIG // vDLZiDje3D/TibQ/sYKW8aRauu0uJtPefAFuAAoApAaS
// SIG // EUgJQPkcGHlnIyTgu9XhUK4b9Q7d4C6BzYCjbFJPkXVV
// SIG // iroi8tLqQXWIL2NVfR5UWpVZytk0gcBfXvZ6tTCCBQkw
// SIG // ggPxoAMCAQICEHS8VusbS9oziV7CM3V8XDMwDQYJKoZI
// SIG // hvcNAQEFBQAwgbQxCzAJBgNVBAYTAlVTMRcwFQYDVQQK
// SIG // Ew5WZXJpU2lnbiwgSW5jLjEfMB0GA1UECxMWVmVyaVNp
// SIG // Z24gVHJ1c3QgTmV0d29yazE7MDkGA1UECxMyVGVybXMg
// SIG // b2YgdXNlIGF0IGh0dHBzOi8vd3d3LnZlcmlzaWduLmNv
// SIG // bS9ycGEgKGMpMDQxLjAsBgNVBAMTJVZlcmlTaWduIENs
// SIG // YXNzIDMgQ29kZSBTaWduaW5nIDIwMDQgQ0EwHhcNMDkw
// SIG // MzEwMDAwMDAwWhcNMTAwNDA5MjM1OTU5WjCBzDELMAkG
// SIG // A1UEBhMCVVMxEzARBgNVBAgTCkNhbGlmb3JuaWExEzAR
// SIG // BgNVBAcTClNhbiBSYWZhZWwxFzAVBgNVBAoUDkF1dG9k
// SIG // ZXNrLCBJbmMuMSEwHwYDVQQLFBhQU0VCLUxpY2Vuc2lu
// SIG // ZyAmIEluc3RhbGwxPjA8BgNVBAsTNURpZ2l0YWwgSUQg
// SIG // Q2xhc3MgMyAtIE1pY3Jvc29mdCBTb2Z0d2FyZSBWYWxp
// SIG // ZGF0aW9uIHYyMRcwFQYDVQQDFA5BdXRvZGVzaywgSW5j
// SIG // LjCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAmeyo
// SIG // XUqsM3gsliL4M1tThOIixcSmppT1AI04curyMTgKCrT6
// SIG // vIaC74ZsEki5wseN6FoAwzeZUJZWPbbPV0qekjTQySBs
// SIG // OYONAd1oU3S2a86Cujy+zxcfryQA+GqYZuG+j1SsLUy5
// SIG // ASBEv4zkQjfWpHMOI8JRdQr2RgVJ/C3LvFcCAwEAAaOC
// SIG // AX8wggF7MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeA
// SIG // MEAGA1UdHwQ5MDcwNaAzoDGGL2h0dHA6Ly9DU0MzLTIw
// SIG // MDQtY3JsLnZlcmlzaWduLmNvbS9DU0MzLTIwMDQuY3Js
// SIG // MEQGA1UdIAQ9MDswOQYLYIZIAYb4RQEHFwMwKjAoBggr
// SIG // BgEFBQcCARYcaHR0cHM6Ly93d3cudmVyaXNpZ24uY29t
// SIG // L3JwYTATBgNVHSUEDDAKBggrBgEFBQcDAzB1BggrBgEF
// SIG // BQcBAQRpMGcwJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3Nw
// SIG // LnZlcmlzaWduLmNvbTA/BggrBgEFBQcwAoYzaHR0cDov
// SIG // L0NTQzMtMjAwNC1haWEudmVyaXNpZ24uY29tL0NTQzMt
// SIG // MjAwNC1haWEuY2VyMB8GA1UdIwQYMBaAFAj1Uej7/j09
// SIG // ZDZ8aM9beKjfucU3MBEGCWCGSAGG+EIBAQQEAwIEEDAW
// SIG // BgorBgEEAYI3AgEbBAgwBgEBAAEB/zANBgkqhkiG9w0B
// SIG // AQUFAAOCAQEAEhMhyHuuFsZagEh6O0zAq+6z0EuhaaqI
// SIG // A/hY0xRjZSyBSoQGwwX1pcNyaFf4TTm/xobUutgT7Ct+
// SIG // l/Xl+RbntwVRkyMSKWGX4CtIKuR70vdqREuNEW9exz0M
// SIG // Ck+lZlPZupJe/OA9cZr1x2M296RHRXKK8lCaE5bexPD/
// SIG // k462NFYSZYfs0DwBMz9Ui+kiFcjnsnUpTGoAI7/Xg6Bn
// SIG // t7tzXU5emeIw9AIZt+64XKOvh5BL1VJ/WuD2rjqCwBBP
// SIG // 4NRD2cOa905LKi0qNHp9KyZPE8IJIK2XgTTX9L+Cw7mT
// SIG // Q2kmYtBmz/9/xjeIVrbwEqZeEfbLiSW2QRysH5RA7oou
// SIG // UjGCA6owggOmAgEBMIHJMIG0MQswCQYDVQQGEwJVUzEX
// SIG // MBUGA1UEChMOVmVyaVNpZ24sIEluYy4xHzAdBgNVBAsT
// SIG // FlZlcmlTaWduIFRydXN0IE5ldHdvcmsxOzA5BgNVBAsT
// SIG // MlRlcm1zIG9mIHVzZSBhdCBodHRwczovL3d3dy52ZXJp
// SIG // c2lnbi5jb20vcnBhIChjKTA0MS4wLAYDVQQDEyVWZXJp
// SIG // U2lnbiBDbGFzcyAzIENvZGUgU2lnbmluZyAyMDA0IENB
// SIG // AhB0vFbrG0vaM4lewjN1fFwzMAkGBSsOAwIaBQCggbQw
// SIG // GQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYB
// SIG // BAGCNwIBCzEOMAwGCisGAQQBgjcCARUwIwYJKoZIhvcN
// SIG // AQkEMRYEFOEFryxYXNRziEXH+tVExpd8TmblMFQGCisG
// SIG // AQQBgjcCAQwxRjBEoCaAJABBAHUAdABvAGQAZQBzAGsA
// SIG // IABDAG8AbQBwAG8AbgBlAG4AdKEagBhodHRwOi8vd3d3
// SIG // LmF1dG9kZXNrLmNvbSAwDQYJKoZIhvcNAQEBBQAEgYAI
// SIG // mby8bgokFcsngOCoR7KsbKc+31EixcbFsHkENyGuoSaN
// SIG // LX2+G/Fl8xAZlOIaCN5+vlJxhuZx/wDRoaO2ypRFXgaF
// SIG // iLDO5iUuFww36PjSxWXzYf4d79gDk5U69kAT6mVXnigz
// SIG // qY1crFRGhTr9wy9kLTq2jet16r9icBe1OQFxmqGCAX8w
// SIG // ggF7BgkqhkiG9w0BCQYxggFsMIIBaAIBATBnMFMxCzAJ
// SIG // BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5j
// SIG // LjErMCkGA1UEAxMiVmVyaVNpZ24gVGltZSBTdGFtcGlu
// SIG // ZyBTZXJ2aWNlcyBDQQIQOCXX+vhhr570kOcmtdZa1TAJ
// SIG // BgUrDgMCGgUAoF0wGAYJKoZIhvcNAQkDMQsGCSqGSIb3
// SIG // DQEHATAcBgkqhkiG9w0BCQUxDxcNMDkxMTIwMDAwNzM4
// SIG // WjAjBgkqhkiG9w0BCQQxFgQU1PfalzLqPDzzmGdVufkO
// SIG // FBhu2h8wDQYJKoZIhvcNAQEBBQAEgYAG2vWCBzJiPZI2
// SIG // cY9FDwICon3ovUZt/Lel33e9pjKDUua0Y1TJN3mafERl
// SIG // ejUR9g5MKALrIvGE1xPjYiCCr1oR4psezCzATIBvGnVm
// SIG // +lgFQv6myibtdmGbq9gLQhKTJGVlMtedA/1TLBsBDukg
// SIG // C3qDk/eUVKo5SPnCFenjO5Ivaw==
// SIG // End signature block
